**********************************************************************************
* FOR LOG
cap log close                       
clear                             

log using "./log/build_beta_LR.log.do", replace text

* FOR LOG
display "$S_TIME  $S_DATE"
**********************************************************************************


**********************************************************************************
set more off
cap prog drop _all
**********************************************************************************


**********************************************************************************
use "./output/betas_annuals.dta", clear  /* These are annualized betas constructed from daily database */
**********************************************************************************


* Harmonize the data 
gen year = datey
**********************************************************************************


**********************************************************************************
****** PART 2: Merging with EIA trade agreement data
gen ISOPAIR = base_country + foreign_country

sort ISOPAIR year
quietly by ISOPAIR year: gen dup = cond(_N==1,0,_n)
drop if dup >= 2
drop dup

merge 1:1 year ISOPAIR using "../task_data/input/EIA Database April 30 2017_Stata 14 Version.dta"
* These are the country-pairs we lose observations:
tab ISOPAIR if _merge == 1 
* These are the years we lose observations:
tab year if _merge == 1
drop if _merge == 2 /* keeping only master data */
drop _merge

/* Extending EIA database */
egen id = group(ISOPAIR)
xtset id year
replace EIA = l.EIA if year > 2012
merge 1:1 year ISOPAIR using "../task_data/output/EIA_extended.dta"
drop if _merge == 2 /* keeping only master data */

replace EIA = EIA_e if year > 2012 & EIA_e != .
sort id year
replace EIA = l.EIA if _merge != 3 & year > 2012 /* fill EIA variables for the extended sample! */

drop _merge


**************************************************************************
***************** Identifying the only bilateral deals *******************
**************************************************************************

sort id year

gen deal_change = 0
replace deal_change = 1 if EIA - l.EIA > 0 

bys year: egen deal_counter  = sum(deal_change)

gen deal_change_OWPTA = deal_change == 1 & EIA == 1
gen deal_change_TWPTA = deal_change == 1 & EIA == 2
gen deal_change_FTA = deal_change == 1 & EIA == 3
gen deal_change_CUCMECU = deal_change == 1 & EIA >= 4

tab deal_change_OWPTA
tab deal_change_TWPTA
tab deal_change_FTA
tab deal_change_CUCMECU

bys year: egen deal_counter_OWPTA  = sum(deal_change_OWPTA)
bys year: egen deal_counter_TWPTA  = sum(deal_change_TWPTA)
bys year: egen deal_counter_FTA  = sum(deal_change_FTA)
bys year: egen deal_counter_CUCMECU  = sum(deal_change_CUCMECU)

tab deal_counter_OWPTA
tab deal_counter_TWPTA
tab deal_counter_FTA
tab deal_counter_CUCMECU

**** Identifying if a country had only one partner in the agreement:
bys ISOEX year: egen sum_c1_OWPTA = sum(deal_change_OWPTA)
bys ISOEX year: egen sum_c1_TWPTA = sum(deal_change_TWPTA)
bys ISOEX year: egen sum_c1_FTA = sum(deal_change_FTA)
bys ISOEX year: egen sum_c1_CUCMECU = sum(deal_change_CUCMECU)

gen deal_change_OWPTA_un = deal_change_OWPTA == 1 & sum_c1_OWPTA == 1
gen deal_change_TWPTA_un = deal_change_TWPTA == 1 & sum_c1_TWPTA == 1
gen deal_change_FTA_un = deal_change_FTA == 1 & sum_c1_FTA == 1
gen deal_change_CUCMECU_un = deal_change_CUCMECU == 1 & sum_c1_CUCMECU == 1

** Some statistics
unique(ISOPAIR) if deal_change_OWPTA == 1
unique(ISOPAIR) if deal_change_TWPTA == 1
unique(ISOPAIR) if deal_change_FTA == 1
unique(ISOPAIR) if deal_change_CUCMECU == 1
*unique(ISOPAIR) if deal_change_FTA == 1 | deal_change_CUCMECU == 1
unique(ISOPAIR) if deal_change_OWPTA_un == 1
unique(ISOPAIR) if deal_change_TWPTA_un == 1 
unique(ISOPAIR) if deal_change_FTA_un == 1
unique(ISOPAIR) if deal_change_CUCMECU_un == 1
*unique(ISOPAIR) if deal_change_FTA_un == 1 | deal_change_CUCMECU_un == 1 

drop deal_counter deal_counter_OWPTA deal_counter_TWPTA deal_counter_FTA deal_counter_CUCMECU
**************************************************************************


**************************************************************************
* Adding PEGS
cap drop _merge
sort base foreign year
merge 1:1 base foreign year using "../task_data/output/pegs.dta"
drop if _merge == 2
drop _merge

replace peg = 0 if peg == .
replace peg2 = 0 if peg2 == .
**********************************************************************************

**********************************************************************************
*Adding gravity variables and gdp

cap drop _merge
sort ISOPAIR year
merge 1:1 ISOPAIR year using "../task_data/output/gravity.dta"
drop if _merge == 2
drop _merge
**********************************************************************************

**********************************************************************************
****** PART 3: Merging with trade variables:
** Trade variables constructed from IMF by ERIK
cap drop _merge
merge 1:1 year ISOPAIR using "../task_data/output/imf_trade_clean_temp.dta"
* These are the country-pairs we loose observations:
* tab ISOPAIR if _merge == 1 
* These are the years we loose observations:
* tab year if _merge == 1
drop if _merge == 2 


save "./output/LRbetas_daily_trade.dta", replace 
**********************************************************************************


** REPEAT PROCESS FOR PCAs (SYSTEMATIC)

**********************************************************************************
use "./output/betas_annuals_PCA.dta", clear  /* These are annualized betas constructed from daily database and base factors from PCA */
**********************************************************************************


* Harmonize the data 
gen year = datey
**********************************************************************************


**********************************************************************************
****** PART 2: Merging with EIA trade agreement data
gen ISOPAIR = base_country + foreign_country

sort ISOPAIR year
quietly by ISOPAIR year: gen dup = cond(_N==1,0,_n)
drop if dup >= 2
drop dup

merge 1:1 year ISOPAIR using "../task_data/input/EIA Database April 30 2017_Stata 14 Version.dta"
* These are the country-pairs we lose observations:
tab ISOPAIR if _merge == 1 
* These are the years we lose observations:
tab year if _merge == 1
drop if _merge == 2 /* keeping only master data */
drop _merge

/* Extending EIA database */
egen id = group(ISOPAIR)
xtset id year
replace EIA = l.EIA if year > 2012
merge 1:1 year ISOPAIR using "../task_data/output/EIA_extended.dta"
drop if _merge == 2 /* keeping only master data */

replace EIA = EIA_e if year > 2012 & EIA_e != .
sort id year
replace EIA = l.EIA if _merge != 3 & year > 2012 /* fill EIA variables for the extended sample! */

drop _merge


**************************************************************************
***************** Identifying the only bilateral deals *******************
**************************************************************************

sort id year

gen deal_change = 0
replace deal_change = 1 if EIA - l.EIA > 0 

bys year: egen deal_counter  = sum(deal_change)

gen deal_change_OWPTA = deal_change == 1 & EIA == 1
gen deal_change_TWPTA = deal_change == 1 & EIA == 2
gen deal_change_FTA = deal_change == 1 & EIA == 3
gen deal_change_CUCMECU = deal_change == 1 & EIA >= 4

tab deal_change_OWPTA
tab deal_change_TWPTA
tab deal_change_FTA
tab deal_change_CUCMECU

bys year: egen deal_counter_OWPTA  = sum(deal_change_OWPTA)
bys year: egen deal_counter_TWPTA  = sum(deal_change_TWPTA)
bys year: egen deal_counter_FTA  = sum(deal_change_FTA)
bys year: egen deal_counter_CUCMECU  = sum(deal_change_CUCMECU)

tab deal_counter_OWPTA
tab deal_counter_TWPTA
tab deal_counter_FTA
tab deal_counter_CUCMECU

**** Identifying if a country had only one partner in the agreement:
bys ISOEX year: egen sum_c1_OWPTA = sum(deal_change_OWPTA)
bys ISOEX year: egen sum_c1_TWPTA = sum(deal_change_TWPTA)
bys ISOEX year: egen sum_c1_FTA = sum(deal_change_FTA)
bys ISOEX year: egen sum_c1_CUCMECU = sum(deal_change_CUCMECU)

gen deal_change_OWPTA_un = deal_change_OWPTA == 1 & sum_c1_OWPTA == 1
gen deal_change_TWPTA_un = deal_change_TWPTA == 1 & sum_c1_TWPTA == 1
gen deal_change_FTA_un = deal_change_FTA == 1 & sum_c1_FTA == 1
gen deal_change_CUCMECU_un = deal_change_CUCMECU == 1 & sum_c1_CUCMECU == 1

** Some statistics
unique(ISOPAIR) if deal_change_OWPTA == 1
unique(ISOPAIR) if deal_change_TWPTA == 1
unique(ISOPAIR) if deal_change_FTA == 1
unique(ISOPAIR) if deal_change_CUCMECU == 1
*unique(ISOPAIR) if deal_change_FTA == 1 | deal_change_CUCMECU == 1
unique(ISOPAIR) if deal_change_OWPTA_un == 1
unique(ISOPAIR) if deal_change_TWPTA_un == 1 
unique(ISOPAIR) if deal_change_FTA_un == 1
unique(ISOPAIR) if deal_change_CUCMECU_un == 1
*unique(ISOPAIR) if deal_change_FTA_un == 1 | deal_change_CUCMECU_un == 1 

drop deal_counter deal_counter_OWPTA deal_counter_TWPTA deal_counter_FTA deal_counter_CUCMECU
**************************************************************************


**************************************************************************
* Adding PEGS
cap drop _merge
sort base foreign year
merge 1:1 base foreign year using "../task_data/output/pegs.dta"
drop if _merge == 2
drop _merge

replace peg = 0 if peg == .
replace peg2 = 0 if peg2 == .
**********************************************************************************

**********************************************************************************
*Adding gravity variables and gdp

cap drop _merge
sort ISOPAIR year
merge 1:1 ISOPAIR year using "../task_data/output/gravity.dta"
drop if _merge == 2
drop _merge
**********************************************************************************

**********************************************************************************
****** PART 3: Merging with trade variables:
** Trade variables constructed from IMF by ERIK
cap drop _merge
merge 1:1 year ISOPAIR using "../task_data/output/imf_trade_clean_temp.dta"
drop if _merge == 2 


save "./output/LRbetas_daily_trade_PCA.dta", replace 
**********************************************************************************


** REPEAT PROCESS FOR PCAs (RESIDUAL)

**********************************************************************************
use "./output/betas_annuals_PCA_resid.dta", clear  /* These are annualized betas constructed from daily database and base factors from PCA */
**********************************************************************************


* Harmonize the data 
gen year = datey
**********************************************************************************


**********************************************************************************
****** PART 2: Merging with EIA trade agreement data
gen ISOPAIR = base_country + foreign_country

sort ISOPAIR year
quietly by ISOPAIR year: gen dup = cond(_N==1,0,_n)
drop if dup >= 2
drop dup

merge 1:1 year ISOPAIR using "../task_data/input/EIA Database April 30 2017_Stata 14 Version.dta"
* These are the country-pairs we lose observations:
tab ISOPAIR if _merge == 1 
* These are the years we lose observations:
tab year if _merge == 1
drop if _merge == 2 /* keeping only master data */
drop _merge

/* Extending EIA database */
egen id = group(ISOPAIR)
xtset id year
replace EIA = l.EIA if year > 2012
merge 1:1 year ISOPAIR using "../task_data/output/EIA_extended.dta"
drop if _merge == 2 /* keeping only master data */

replace EIA = EIA_e if year > 2012 & EIA_e != .
sort id year
replace EIA = l.EIA if _merge != 3 & year > 2012 /* fill EIA variables for the extended sample! */

drop _merge


**************************************************************************
***************** Identifying the only bilateral deals *******************
**************************************************************************

sort id year

gen deal_change = 0
replace deal_change = 1 if EIA - l.EIA > 0 

bys year: egen deal_counter  = sum(deal_change)

gen deal_change_OWPTA = deal_change == 1 & EIA == 1
gen deal_change_TWPTA = deal_change == 1 & EIA == 2
gen deal_change_FTA = deal_change == 1 & EIA == 3
gen deal_change_CUCMECU = deal_change == 1 & EIA >= 4

tab deal_change_OWPTA
tab deal_change_TWPTA
tab deal_change_FTA
tab deal_change_CUCMECU

bys year: egen deal_counter_OWPTA  = sum(deal_change_OWPTA)
bys year: egen deal_counter_TWPTA  = sum(deal_change_TWPTA)
bys year: egen deal_counter_FTA  = sum(deal_change_FTA)
bys year: egen deal_counter_CUCMECU  = sum(deal_change_CUCMECU)

tab deal_counter_OWPTA
tab deal_counter_TWPTA
tab deal_counter_FTA
tab deal_counter_CUCMECU

**** Identifying if a country had only one partner in the agreement:
bys ISOEX year: egen sum_c1_OWPTA = sum(deal_change_OWPTA)
bys ISOEX year: egen sum_c1_TWPTA = sum(deal_change_TWPTA)
bys ISOEX year: egen sum_c1_FTA = sum(deal_change_FTA)
bys ISOEX year: egen sum_c1_CUCMECU = sum(deal_change_CUCMECU)

gen deal_change_OWPTA_un = deal_change_OWPTA == 1 & sum_c1_OWPTA == 1
gen deal_change_TWPTA_un = deal_change_TWPTA == 1 & sum_c1_TWPTA == 1
gen deal_change_FTA_un = deal_change_FTA == 1 & sum_c1_FTA == 1
gen deal_change_CUCMECU_un = deal_change_CUCMECU == 1 & sum_c1_CUCMECU == 1

** Some statistics
unique(ISOPAIR) if deal_change_OWPTA == 1
unique(ISOPAIR) if deal_change_TWPTA == 1
unique(ISOPAIR) if deal_change_FTA == 1
unique(ISOPAIR) if deal_change_CUCMECU == 1
unique(ISOPAIR) if deal_change_OWPTA_un == 1
unique(ISOPAIR) if deal_change_TWPTA_un == 1 
unique(ISOPAIR) if deal_change_FTA_un == 1
unique(ISOPAIR) if deal_change_CUCMECU_un == 1

drop deal_counter deal_counter_OWPTA deal_counter_TWPTA deal_counter_FTA deal_counter_CUCMECU
**************************************************************************


**************************************************************************
* Adding PEGS
cap drop _merge
sort base foreign year
merge 1:1 base foreign year using "../task_data/output/pegs.dta"
drop if _merge == 2
drop _merge

replace peg = 0 if peg == .
replace peg2 = 0 if peg2 == .
**********************************************************************************

**********************************************************************************
*Adding gravity variables and gdp

cap drop _merge
sort ISOPAIR year
merge 1:1 ISOPAIR year using "../task_data/output/gravity.dta"
drop if _merge == 2
drop _merge
**********************************************************************************

**********************************************************************************
****** PART 3: Merging with trade variables:
** Trade variables constructed from IMF by ERIK
cap drop _merge
merge 1:1 year ISOPAIR using "../task_data/output/imf_trade_clean_temp.dta"
* These are the country-pairs we loose observations:
* tab ISOPAIR if _merge == 1 
* These are the years we loose observations:
* tab year if _merge == 1
drop if _merge == 2 


save "./output/LRbetas_daily_trade_PCA_resid.dta", replace 
**********************************************************************************


**********************************************************************************
* FOR LOG
display "$S_TIME  $S_DATE"

log close
**********************************************************************************



